#open "graphics";;
open_graph "";;
let round x =
  if x >=. 0.0  then int_of_float (x +. 0.5)
  else - (int_of_float (-. x +. 0.5));;
  
type tat =   { mutable X : float; mutable Y : float;
     mutable Vise : float; mutable Lev : bool };;
     
let crayon = { X = 0.0; Y = 0.0; Vise = 0.0; Lev = false };;

let fixe_crayon b = crayon.Lev <- b;;
let pi_sur_180 =    let pi = 4.0 *. (atan 1.0) in pi /. 180.0;;

let tourne angle =
    crayon.Vise <- (crayon.Vise +. angle *. pi_sur_180);;
    
let avance d =    let dx = d *. cos (crayon.Vise)
    and dy = d *. sin (crayon.Vise) in    crayon.X <- crayon.X +. dx;
    crayon.Y <- crayon.Y +. dy;    if crayon.Lev
    then moveto (round crayon.X) (round crayon.Y)    else lineto (round crayon.X) (round crayon.Y);;

let couleur_du_trac = foreground;;

let couleur_du_fond = background;;

let zro_x = float_of_int ((size_x ()) / 2);;

let zro_y = float_of_int ((size_y ()) / 2);;
let vide_cran () =
    clear_graph();
    set_color couleur_du_trac;
    crayon.X <- zro_x;
    crayon.Y <- zro_y;
    crayon.Vise <- 0.0;
    crayon.Lev <- false;
    moveto (round crayon.X) (round crayon.Y);;